//
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  N o t e b o o k   H a r d w a r e   C o n t r o l   A C P I   D L L
//  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//  for Fujitsu Siemens Notebooks
//
//  This file is provided "as is" with no expressed or implied warranty.
//  The authors accepts no liability for any damage/loss of business that
//  this product may cause.
//
//  Last Update: 02 May 2007
//
public static class FUJITSU_SIEMENS
{

    #region Notebook Fujitsu Siemens Amilo L7300 : class L7300
    //
    // class authors: Manfred Jaider, Klaus Weglehner
    //
    public static class L7300
    {

        #region Class for Fujitsu Siemens Amilo L7300 FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control";               // Description of current class
            public const bool default_enabled = false;                               // false = By default the current class is disabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon
            public static bool initialisation = false;                              // Initialisation variable: on initialisation NHC will set this variable to true; after the initialisation NHC will set this variabel to false

            // Package for ACPI FAN Control (default value)
            // - - - - - - - - - - - - - - -
            //
            // Name (HILM, Package (0x04)
            // {
            //    0x37,     // 55°C     <- FAN ON low level
            //    0x41,     // 65°C     <- FAN ON middle level
            //    0x5A,     // 90°C     <- FAN ON high level
            //    0x64      // 100°C    <- FAN ON maximum level
            // })
            // Name (LOLM, Package (0x04)
            // {
            //    0x00, 
            //    0x32,     // 50°C     <- FAN OFF low level
            //    0x3C,     // 60°C     <- FAN OFF middle level
            //    0x50      // 80°C     <- FAN OFF high level
            // })            

            #region  Value class for LOW_LEVEL_OFF : class LOW_LEVEL_OFF
            //
            public static class LOW_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF low level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_off = 50;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 0;                         // minimum input value
                    public const int nhc_maximum_value = 65;                        // maximum input value
                    public const int nhc_default_value = 50;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.THRM.LOLM", "PKG[1]", low_level_off) == true)  // set the low_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for LOW_LEVEL_ON : class LOW_LEVEL_ON
            //
            public static class LOW_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON low level";               // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int low_level_on = 55;                                // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 5;                         // minimum input value
                    public const int nhc_maximum_value = 70;                        // maximum input value
                    public const int nhc_default_value = 55;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.THRM.HILM", "PKG[0]", low_level_on) == true)   // set the low_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_OFF : class MIDDLE_LEVEL_OFF
            //
            public static class MIDDLE_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF middle level";           // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_off = 60;                            // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 10;                        // minimum input value
                    public const int nhc_maximum_value = 75;                        // maximum input value
                    public const int nhc_default_value = 60;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.THRM.LOLM", "PKG[2]", middle_level_off) == true)   // set the middle_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for MIDDLE_LEVEL_ON : class MIDDLE_LEVEL_ON
            //
            public static class MIDDLE_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON middle level";            // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int middle_level_on = 65;                             // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 15;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 65;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.THRM.HILM", "PKG[1]", middle_level_on) == true)    // set the middle_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_OFF : class HIGH_LEVEL_OFF
            //
            public static class HIGH_LEVEL_OFF
            {
                // Properties of the value class
                public const string description = "FAN OFF high level";             // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_off = 80;                              // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 20;                        // minimum input value
                    public const int nhc_maximum_value = 80;                        // maximum input value
                    public const int nhc_default_value = 80;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.THRM.LOLM", "PKG[3]", high_level_off) == true) // set the high_level_off value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region Value class for HIGH_LEVEL_ON : class HIGH_LEVEL_ON
            //
            public static class HIGH_LEVEL_ON
            {
                // Properties of the value class
                public const string description = "FAN ON high level";              // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int high_level_on = 90;                               // It must have the same name as the class (case are ignored)
                public const string unit = "°C";                                    // unit of value

                // With this class it is possible to change the value in NHC on runtime
                public static class NHC_WRITE
                {
                    public const bool nhc_write = true;                             // true -> it is possible to change the value in NHC
                    public const int nhc_minimum_value = 25;                        // minimum input value
                    public const int nhc_maximum_value = 90;                        // maximum input value
                    public const int nhc_default_value = 90;                        // default value
                    public static bool nhc_on_write()                               // Optional function - NHC will call this function if the user change the value on runtime and on NHC initialisation
                    {
                        if (ACPI.PACKAGE.Write("_TZ.THRM.HILM", "PKG[2]", high_level_on) == true)  // set the high_level_on value in the package
                        {
                            return refresh_thermal_zone();                          // refresh the ThermalZone (Temperature and FAN Speed)
                        }
                        else
                        {
                            return false;
                        }
                    }
                }
            }
            //
            #endregion

            #region __refresh_thermal_zone()
            //
            private static bool __refresh_thermal_zone()
            {
                bool result = false;
                int value = 0;
                //
                // TZ refresh with "_TZ.THRM._TMP"
                //
                if (ACPI.METHOD.SetValue("_TZ.THRM.THIN", 1) == false)      // before call _TMP we have to set THIN to "1"
                {
                    return false;
                }                
                if (ACPI.METHOD.GetValue("_TZ.THRM._TMP", ref value) == false)
                {
                    return false;
                }
                //
                // TZ refresh with _GPE._L01
                //
                if (ACPI.METHOD.Call("_GPE._L01") == false)
                {
                    return false;
                }
                //
                // TZ refresh with PowerResource FN10 and FN11
                //
                int status = 0;
                if (ACPI.METHOD.GetValue("_TZ.FN10._STA", ref status) == false)
                {
                    return false;
                }
                if (status == 0)
                {
                    result = ACPI.METHOD.Call("_TZ.FN10._OFF");
                }
                else
                {
                    result = ACPI.METHOD.Call("_TZ.FN10._ON");
                }
                if (result == false)
                {
                    return false;
                }
                else
                {
                    if (ACPI.METHOD.GetValue("_TZ.FN11._STA", ref status) == false)
                    {
                        return false;
                    }
                    if (status == 0)
                    {
                        result = ACPI.METHOD.Call("_TZ.FN11._OFF");
                    }
                    else
                    {
                        result = ACPI.METHOD.Call("_TZ.FN11._ON");
                    }
                    if (result == false)
                    {
                        return false;
                    }
                }
                //
                return true;
            }
            //
            #endregion

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return __refresh_thermal_zone();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            private static bool refresh_thermal_zone()
            {
                if (initialisation == false)
                {
                    return __refresh_thermal_zone();                // refresh the ThermalZone (Temperature and FAN Speed)
                }
                else
                {
                    return true;                                    // on NHC initialisation skip the ThermalZone refresh
                }
            }
        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Fujitsu Siemens AMILO Xi 1546 : class XI1546
    //
    // class author: tapodufeu@free.fr
    // class version: v1.0
    // info: also Works with 1526 an 1554 (because some "if" exist in the ACPI, so I guess acpi is the same for those models).
    //
    public static class XI1546
    {

        #region LCD Brightness control : class BRIGHTNESS
        //
        // The class must have the name BRIGHTNESS
        //
        public static class BRIGHTNESS
        {
            // Default constants for the brightness class
            public const string description = "LCD Brightness Control (Not working)";             // Description of current class
            public const bool default_enabled = false;                                // true = By default the current class is enabled in NHC
            public const int icon = 1;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            // Constants for the brightness control (NHC will need this constants)
            public const int minimum_brightness_level = 0;
            public const int maximum_brightness_level = 7;       // seems to be that for all fujitsus siemens. I tried on my own and found 7. Ok for me
            public const int brightness_level_step = 1;

            #region Value class for brightness_level : class BRIGHTNESS_LEVEL
            // 
            public static class BRIGHTNESS_LEVEL
            {
                public const string description = "Current LCD brightness level";   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC
                public static int brightness_level = 0;                             // It must have the same name as the class (case are ignored)
            }
            //
            #endregion

            // Function to set the brightness (it must have the name set_brightness)
            public static bool set_brightness(int new_level)
            {
                //return ACPI.METHOD.Call ("_SB.PCI0.LPCB.EC0._Q20");
                return true;
            }

            // Function to get and refresh the brightness level (it must have the name set_brightness)
            public static bool get_brightness(ref int level)
            {
                return true;
            }
        }
        //
        #endregion

        #region Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = true;                                // true = By default the current class is enabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            public static class WLAN_STATUS
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_status = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class LCD_PANEL
            {
                // Properties of the value class
                public const string description = "LCD Panel";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int lcd_panel = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class CRT_DVI
            {
                // Properties of the value class
                public const string description = "CRT and DVI";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int crt_dvi = 0;                                  // It must have the same name as the class (case are ignored)
            }

            public static bool init()
            {
                return refresh();
            }
            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                bool result0 = ACPI.NAME.Read("DSEN", ref WLAN_STATUS.wlan_status); // same as another fujitsu notebokk. Don't know if it's ok !!
                bool result1 = ACPI.NAME.Read("_SB.PCI0.PEGP.VGA.CRT._DGS", ref LCD_PANEL.lcd_panel);
                bool result7 = ACPI.NAME.Read("_SB.PCI0.PEGP.VGA.DVI._DGS", ref CRT_DVI.crt_dvi);
                return true;
            }
        }
        //
        #endregion

        #region Hardware control : class SENSORS
        //
        public static class SENSORS
        {
            // Info
            public const string description = "Temperatures";                   // Description of current class
            public const bool default_enabled = true;                                // true = By default the current class is enabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon


            #region
            //
            public static class INFO0
            {
                // Properties of the value class
                public const string description = "Processor";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int info0 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class INFO1
            {
                // Properties of the value class
                public const string description = "Processor works under";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int info1 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class INFO2
            {
                // Properties of the value class
                public const string description = "Processor critical temperature";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int info2 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class INFO3
            {
                // Properties of the value class
                public const string description = "Motherboard 1";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int info3 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class INFO4
            {
                // Properties of the value class
                public const string description = "Motherboard 2";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int info4 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            //
            //            public static class INFO5
            //            {
            //                public const string description = "Info 5";           
            //                public const bool nhc_visible = true;                 
            //                public static int info5 = 0;                     
            //            }
            //            public static class INFO6
            //            {
            //                public const string description = "Info 6";        
            //                public const bool nhc_visible = true;         
            //                public static int info6;               
            //            }
            //            public static class INFO7
            //            {
            //                public const string description = "Info 7";      
            //                public const bool nhc_visible = true;         
            //                public static int info7 = 0;                
            //            }
            //            public static class INFO8
            //            {
            //                public const string description = "Info 8";  
            //                public const bool nhc_visible = true;
            //                public static int info8 = 0;
            //             }
            //            public static class INFO9
            //            {
            //                public const string description = "Info 9";
            //                public const bool nhc_visible = true;
            //                public static int info9 = 0;
            //            } 
            //
            #endregion
            public static bool init()
            {
                return refresh();                    // refresh the ThermalZone (Temperature and FAN Speed)
            }
            // internal refresh function for the ThermalZone
            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                bool result = ACPI.METHOD.Call("_TZ.THRM");                // don't know why, but let it here... will see later
                bool result0 = ACPI.METHOD.GetValue("_SB.PCI0.LPCB.EC0.XHPP", ref INFO0.info0);
                bool result1 = ACPI.FIELD.Read("PSVT", ref INFO1.info1);
                bool result2 = ACPI.FIELD.Read("CRTT", ref INFO2.info2);
                bool result3 = ACPI.FIELD.Read("PCP0", ref INFO3.info3);
                bool result4 = ACPI.FIELD.Read("PCP1", ref INFO4.info4);
                // for testing
                //				bool result5 = ACPI.NAME.Read ("_SB.PCI0.PEGP.VGA.LCD._DGS",ref INFO5.info5);
                //				bool result6 = ACPI.NAME.Read ("_SB.PCI0.PEGP.VGA.CRT._DGS",ref INFO6.info6);
                //				bool result7 = ACPI.NAME.Read ("_SB.PCI0.PEGP.VGA.DVI._DGS",ref INFO7.info7);
                //				bool result8 = ACPI.NAME.Read ("_SB.PCI0.PEGP.VGA.DVIA._DGS",ref INFO5.info5);
                //				bool result9 = ACPI.FIELD.Read ("_SB.PCI0.LPCB.EC0.ACIN",ref INFO9.info9);
                //				byte n0 = 0;
                //				byte n1 = 0;
                //				byte n2 = 0;
                //				byte n3 = 0;
                //				bool result6 = ACPI.BUFFER.Read ("_SB.PCI0.PEGP.AMW0.STAC",0,ref n0);
                //				bool result7 = ACPI.BUFFER.Read ("_SB.PCI0.PEGP.AMW0.STAC",1,ref n1);
                //				bool result8 = ACPI.BUFFER.Read ("_SB.PCI0.PEGP.AMW0.STAC",2,ref n2);
                //				bool result9 = ACPI.BUFFER.Read ("_SB.PCI0.PEGP.AMW0.STAC",3,ref n3);
                //				INFO6.info6= (int)n0;
                //				INFO7.info7= (int)n1;
                //				INFO8.info8= (int)n2;
                //				INFO9.info9= (int)n3;				

                return result;
            }

        }
        //
        #endregion

        #region FAN control : class FAN
        //
        public static class FAN
        {
            // Info
            public const string description = "Notebook FAN Control (Not working)";               // Description of current class
            public const bool default_enabled = false;                                // true = By default the current class is enabled in NHC
            public const int icon = 2;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            public static class FANROTATION
            {
                // Properties of the value class
                public const string description = "Fan Speed";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fanrotation = 0;                                  // It must have the same name as the class (case are ignored)
                public const string unit = " x RPM";                                // unit of value
            }
            public static class FANLEVEL
            {
                // Properties of the value class
                public const string description = "Fan level";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int fanlevel = 0;                                  // It must have the same name as the class (case are ignored)
                public const string unit = "";                                // unit of value
            }

            // init function -> NHC will call this function on initialisation (after the nhc_on_write() functions)
            public static bool init()
            {
                return refresh();
            }
            // internal refresh function for the ThermalZone
            private static bool refresh()
            {
                return true;
            }
        }
        //
        #endregion

        #region Hardware control : class BATTERY
        //
        public static class BATTERY
        {
            // Info
            public const string description = "Battery";                   // Description of current class
            public const bool default_enabled = true;                                // true = By default the current class is enabled in NHC
            public const int icon = 3;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            public static class BAT0
            {
                // Properties of the value class
                public const string description = "AC is connected";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bat0 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class BAT1
            {
                // Properties of the value class
                public const string description = "Battery is in charge";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bat1 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class BAT2
            {
                // Properties of the value class
                public const string description = "Battery Voltage";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bat2 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class BAT3
            {
                // Properties of the value class
                public const string description = "Battery Capacity";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int bat3 = 0;                                  // It must have the same name as the class (case are ignored)
            }
            //
            public static bool init()
            {
                return refresh();
            }
            // internal refresh
            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                bool result = ACPI.METHOD.GetValue("_SB.PCI0.LPCB.EC0.ACIN", ref BAT0.bat0);
                bool result1 = ACPI.FIELD.Read("_SB.PCI0.LPCB.EC0.XCIN", ref BAT1.bat1);
                bool result2 = ACPI.FIELD.Read("_SB.PCI0.LPCB.EC0.XST3", ref BAT2.bat2);
                bool result3 = ACPI.FIELD.Read("_SB.PCI0.LPCB.EC0.XST2", ref BAT3.bat3);
                return result;
            }

        }
        //
        #endregion

        #region Hardware control : class AUDIO
        //
        public static class AUDIO
        {
            // Info
            public const string description = "Audio System (Not working)";                   // Description of current class
            public const bool default_enabled = false;                                // true = By default the current class is enabled in NHC
            public const int icon = 4;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            public static class VOLUME
            {
                // Properties of the value class
                public const string description = "Audio Volume";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int volume = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class MUTE
            {
                // Properties of the value class
                public const string description = "Audio Mute";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int mute = 0;                                  // It must have the same name as the class (case are ignored)
            }
            //
            public static bool init()
            {
                return refresh();
            }
            // internal refresh
            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                return true;
            }

        }
        //
        #endregion

    }
    //
    #endregion

    #region Notebook Fujitsu Siemens AMILO Pa 1510 : class PA1510
    //
    // class author: Manfred Jaider
    //
    public static class PA1510
    {

        #region Hardware control : class HARDWARE
        //
        public static class HARDWARE
        {
            // Info
            public const string description = "Hardware Control";                   // Description of current class
            public const bool default_enabled = true;                                // true = By default the current class is enabled in NHC
            public const int icon = 0;                                              // 0 = Hardware icon, 1 = Brightness icon, 2 = Fan icon, 3 = Battery icon, 4 = Audio icon

            public static class WLAN_STATUS
            {
                // Properties of the value class
                public const string description = "Wireless LAN";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int wlan_status = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class LCD_PANEL
            {
                // Properties of the value class
                public const string description = "LCD Panel";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int lcd_panel = 0;                                  // It must have the same name as the class (case are ignored)
            }
            public static class CRT_DVI
            {
                // Properties of the value class
                public const string description = "CRT and DVI";                   // Description of current value
                public const bool nhc_visible = true;                               // true -> value is visible in NHC

                // Value
                public static int crt_dvi = 0;                                  // It must have the same name as the class (case are ignored)
            }

            public static bool init()
            {
                return refresh();
            }
            public const int refresh_interval = 1;                                  // <= 1 -> 1 Second; 2 -> 2 Seconds ...
            public static bool refresh()
            {
                int value = 0;
                bool result = ACPI.FIELD.Read("_SB.PCI0.PREV", ref value);
                result = ACPI.NAME.Read("_SB.LID._LID", "LIDS", ref value);
                return true;
            }
        }
        //
        #endregion

    }
    //
    #endregion

}